<?php namespace Symfony\Component\HttpFoundation;

class LaravelRequest extends Request {

    /**
     * Creates a new request with values from PHP's super globals.
     *
     * @return Request A new request
     *
     * @api
     */
    static public function createFromGlobals()
    {
        $request = new static($_GET, $_POST, array(), $_COOKIE, $_FILES, $_SERVER);

        if (0 === strpos($request->server->get('CONTENT_TYPE'), 'application/x-www-form-urlencoded')
            && in_array(strtoupper($request->server->get('REQUEST_METHOD', 'GET')), array('PUT', 'DELETE', 'PATCH'))
        ) {
            parse_str($request->getContent(), $data);
            if (magic_quotes()) $data = array_strip_slashes($data);
            $request->request = new ParameterBag($data);
        }

        return $request;
    }

    /**
     * Get the root URL of the application.
     *
     * @return string
     */
    public function getRootUrl()
    {
        return $this->getScheme().'://'.$this->getHttpHost().$this->getBasePath();
    }

}