## Laravel - A PHP Framework For Web Artisans

Laravel is a clean and classy framework for PHP web development. Freeing you from spaghetti code, Laravel helps you create wonderful applications using simple, expressive syntax. Development should be a creative experience that you enjoy, not something that is painful. Enjoy the fresh air.

### [Official Website & Documentation](http://laravel.com)

### Feature Overview

- Simple routing using Closures or controllers.
- Views and templating.
- Driver based session and cache handling.
- Database abstraction with query builder.
- Authentication.
- Migrations.
- PHPUnit Integration.
- A lot more.

### A Few Examples

**Hello World:**

	Route::get('/', function()
	{
		return "Hello World!":
	});

**Passing Data To Views:**

	Route::get('user/(:num)', function($id)
	{
		$user = DB::table('users')->find($id);

		return View::make('profile')->with('user', $user);
	});

**Redirecting & Flashing Data To The Session:**

	return Redirect::to('profile')->with('message', 'Welcome Back!');

### Contributing to Laravel

Contributions are encouraged and welcome; however, please review the Developer Certificate of Origin in the "license.txt" file included in the repository. All commits must be signed off using the "-s" switch.

	git commit -s -m "this commit will be signed off automatically!"

### License

Laravel is open-sourced software licensed under the MIT License.