<?php
namespace App\Lib\Upyun;

use Illuminate\Support\Facades\Config;
use \UpYun;

class UpyunClient
{

    protected $addr;
    protected $upyun;

    public function __construct()
    {
        $this->addr = Config("app.upyun.addr");
        $bucketname = Config("app.upyun.bucket");
        $username   = Config("app.upyun.username");
        $password   = Config("app.upyun.password");
        $this->upyun = new UpYun($bucketname,$username,$password);
    }

    public function upload($path,$files)
    {
        return $this->upyun->writeFile($path,fopen($files['tmp_name'],"r"),true);
    }

    public function del($url)
    {
        $url = substr($url,strpos($url,$this->addr)+strlen($this->addr),strlen($url));
        try {
            $this->upyun->delete($url);
        } catch (\Exception $e) {
            return false;
        }
    }

}