<?php

namespace App\Lib\Response;

use App\Lib\Response\HttpStatus;

use App\Providers\RouteServiceProvider;


class Response
{

    //method get return
    public static function success($data,$message = "操作成功" ,$code = HttpStatus::HttpSuccess )
    {
        return [
            'code'    => $code ,
            'data'    => $data,
            'message' => $message,
            'api_ver' => RouteServiceProvider::getVersion()
        ];
    }

    //method put,post,head return
    public static function ok ($data = "",$code = HttpStatus::HttpOk)
    {
        return [
            'code'    => $code,
            'data'    => $data,
            'api_ver' => RouteServiceProvider::getVersion()
        ];
    }

    //while error occured return
    public static function error($message = "",$code = HttpStatus::HttpInvalidArgument)
    {
        return [
            'code'    => $code,
            'message' => empty($message)?"操作失败":$message,
            'api_ver' => RouteServiceProvider::getVersion()
        ];
    }
}