<?php

namespace App\Lib\Client;

use App\Lib\Response\HttpStatus;
use Illuminate\Http\Request;

class CurlClient
{
    protected $error;
    protected $method = "GET";
    protected $config;
    protected $data;
    protected $url;
    private $format = "";
    protected $header = [];
    protected $base;

    protected $Exceptions = [
        HttpStatus::HttpNotFound => \App\Exceptions\ApiNotFound::class,
        HttpStatus::HttpUnauthorized => \App\Exceptions\ApiUnauthorized::class,
        HttpStatus::HttpValidationFailed => \App\Exceptions\ApiValidationFailed::class,
        HttpStatus::HttpForbidden  => \App\Exceptions\ApiForbidden::class,
        HttpStatus::HttpInvalidArgument => \Exception::class,
        HttpStatus::HttpTimeout => \App\Exceptions\ApiTimeout::class,
    ];

    public function __construct()
    {
        $this->base = config("apiurl");
    }

    public function setUrl($url)
    {
        $this->url = $url;
    }

    public function getUrl()
    {
       return $this->url;
    }

    /**
     * @param mixed $data
     */
    public function setData($data)
    {
        $this->data = $data;
    }

    /**
     * @param string $method
     */
    public function setMethod($method)
    {
        $this->method = strtoupper($method);
    }

    /**
     * @param array $header
     */
    public function setHeader($header)
    {
        $this->header = array($this->header,$header);
    }

    public function __call($name, $arguments)
    {
        foreach ($arguments as $arg) {
            if (is_string($arg)) {
                $this->url = $arg;
            }elseif(is_array($arg)) {
                $this->data = $arg;
            }
        }
        $this->setMethod($name);
        return $this->curl();
    }

    public function curl()
    {
        $http = curl_init();
        curl_setopt($http,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($http,CURLOPT_URL,$this->base.$this->url);
        curl_setopt($http,CURLOPT_HEADER,false);
        curl_setopt($http,CURLOPT_CUSTOMREQUEST,$this->method);
        curl_setopt($http,CURLOPT_TIMEOUT ,5);
        if ($this->format == "JSON")
        {
            $this->header = array_merge($this->header,['Content-Type:application/json']);
            $this->data = json_encode($this->data);
        }
        if ($this->method === "POST") {
            curl_setopt($http,CURLOPT_POST,true);
        }
        curl_setopt($http,CURLOPT_HTTPHEADER,$this->header);
        if (!empty($this->data)) {
            curl_setopt($http, CURLOPT_POSTFIELDS, $this->data);
        }
        $res = curl_exec($http);
        unset($http);
        if ($res == false) {
            throw new \Exception("服务器无反应,请稍候再试");
        }
        $res = json_decode($res);
        if (json_last_error() > 0) {
            var_dump($this->base.$this->url);
            var_dump($res);
            throw new \Exception("数据解析错误");
        }
        if ($res->code >= 200 && $res->code < 400) {
            return $res->data;
        } else {
            $exception = self::Exceptions[$res->code];
            $msg = is_array($res->message)?implode(";",$res->message):$res->message;
            throw new $exception($msg);
        }
    }

    public function getError()
    {
        return $this->error;
    }

    protected function getSign()
    {
        return sha1("md5",$this->method.$this->url.implode(".",$this->header));
    }
}
