<?php

namespace App\Http\Controllers\Sets\Controller;

use App\Exceptions\ApiNotFound;
use App\Exceptions\ApiUnauthorized;
use App\Http\Controllers\ControllerBase;
use Illuminate\Routing\Controller;
use App\Lib\Response\Response;
use Illuminate\Http\Request;

class Sets extends ControllerBase
{

    protected $prefix = "sets";

    const TIME_BEFORE = 0;
    const TIME_IN     = 1;
    const TIME_AFTER  = 2;

    const SETS_TYPE_NORMAL = 0;
    const SETS_TYPE_TRAVEL = 1;

    protected function after_hook($res)
    {
        $path =  app_path("Lib")."/underscore.php";
        include_once $path;
        $data = [];
        $now = time();
         __()->each($res->data,function($item) use (&$data,$now){
            if (strtotime($item->start_time) > $now) {
                $item->time_status = Sets::TIME_BEFORE;
            } elseif(strtotime($item->end_time) < $now) {
                $item->time_status = Sets::TIME_AFTER;
            } else {
                $item->time_status = Sets::TIME_IN;
            }
            array_push($data,$item);
        });
        $res->data = $data;
        return $res;
    }

    //上下架
    public function shelf_up($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_shelf",0);
            return Response::ok();
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }
    
    //上架
    public function shelf_down($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_shelf",1);
            return Response::ok();
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 新增
     */
    public function store(Request $request)
    {
        $data = $request->all();
        if ($data['type'] == self::SETS_TYPE_NORMAL) {
            $request->merge([
                'abroad' => 0                    //非旅拍套系则视作国内
            ]);
        } else {
            $request->merge([
                'abroad' => $data['abroad']     // 旅拍套系按照传入的值来
            ]);
        }
        if ($data['is_promotion'] == 1 && isset($data['promotion'][0])) {
            $request->merge([
                'n_order_count' => $data['n_cost'] + $data['promotion'][0]['p_cost']
            ]);
        } else {
            $request->merge([
                'n_order_count' => $data['n_cost']
            ]);
        }
        return parent::store($request);
    }

    /**
     * 修改
     */
    public function update($id, Request $request)
    {
        $data = $request->all();
        if ($data['type'] == self::SETS_TYPE_NORMAL) {
            $request->merge([
                'abroad' => 0
            ]);
        } else {
            $request->merge([
                'abroad' => $data['abroad']
            ]);
        }
        if ($data['is_promotion'] == 1 && isset($data['promotion'][0])) {
            $request->merge([
                'n_order_count' => $data['n_cost'] + $data['promotion'][0]['p_cost']
            ]);
        } else {
            $request->merge([
                'n_order_count' => $data['n_cost']
            ]);
        }
        return parent::update($id, $request);
    }
}