<?php

namespace App\Http\Controllers\File\Controller;

use App\Lib\Upyun\UpyunClient;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use App\Lib\Upyun\ImageType;
use App\Lib\Response\Response;


class File extends Controller
{
    protected $uploader;
    protected $type;

    public function upload($uid,$type)
    {
        $this->uploader = new UpyunClient();
        if (empty($_FILES)) {
            return Response::error("无文件待上传");
        }
        if (empty($uid)) {
            return Response::error("请传入用户ID");
        }
        switch (strtolower($type)) {
            case "sets":
                $this->type = ImageType::Sets;
                break;
            case "works":
                $this->type = ImageType::Works;
                break;
            case "banner":
                $this->type = ImageType::Banner;
                break;
            case "choice":
                $this->type = ImageType::Choice;
                break;
            case "category":
                $this->type = ImageType::Category;
                break;
            case "ident":
                $this->type = ImageType::Ident;
                break;
            case "xp":
                $this->type = ImageType::Xp;
                break;
            case "art":
                $this->type = ImageType::Art;
                break;
            default:
                return Response::error("无效的文件类型");
        }
        $path = ImageType::getPath($uid,$this->type);
        $file = null;
        foreach ($_FILES as $_file) {
            $file = $_file;
            break;
        }
        switch ($file['type']) {
            case "image/jpeg":
            case "image/jpg":
                $ext = ".jpg";
                break;
            case "image/png":
                $ext = ".png";
                break;
            default:
                $ext = ".jpg";
        };
        $path .= sha1(uniqid() . $file['name']) . $ext;
        $res = $this->uploader->upload($path,$file);
        return [
            'url'    => Config("app.upyun.addr") . $path,
            'height' => $res['x-upyun-height'],
            'width'  => $res['x-upyun-width'],
            'file_name' => $file['tmp_name']
        ];
    }

    public function editorUpload($uid,$action,Request $request)
    {
        $post = $request->all();
        $CONFIG = json_decode(preg_replace("/\/\*[\s\S]+?\*\//", "",$post['config']), true);
        switch ($action) {
            case 'config':
                $result =  json_encode($CONFIG);
                break;
            case 'uploadscrawl':
            case 'uploadimage':
                $path = ImageType::getPath($uid,ImageType::Editor);
                $file = $_FILES['upfile'];
                switch ($file['type']) {
                    case "image/jpeg":
                    case "image/jpg":
                        $ext = ".jpg";
                        break;
                    case "image/png":
                        $ext = ".png";
                        break;
                    default:
                        $ext = ".jpg";
                };
                $path .= sha1(uniqid() . $file['name']) . $ext;
                $res = $this->uploader->upload($path,$file);
                if ($res !== false) {
                    $result = json_encode([
                        "state" => "SUCCESS",
                        "url" => $res['url'],
                        "title" => $file['name'],
                        "original" => $file['name'],
                        "type" => $file['type'],
                        "size" => $file['size']
                    ]);
                } else {
                    $result = json_encode([
                        "state" => "上传失败"
                    ]);
                }
                break;
            case 'catchimage':
                $result = $this->saveRemote();
                break;
            default:
                $result = json_encode(array(
                    'state'=> '请求地址出错'
                ));
                break;
        }
        echo $result;
    }

}