<?php

namespace App\Http\Controllers\Article\Controller;

use App\Exceptions\ApiNotFound;
use App\Exceptions\ApiUnauthorized;
use App\Http\Controllers\ControllerBase;
use Illuminate\Routing\Controller;
use App\Lib\Response\Response;
use Illuminate\Http\Request;

class Article extends ControllerBase
{

    protected $prefix = "art";

    const Article = 0;
    const Active  = 1;

    const type = [
        self::Article => "攻略",
        self::Active  => "动态"
    ];


    public function index($query = "",$checkUid = true)
    {
        $string = $this->combine(['type' => self::Article]);
        return parent::index($string);
    }

    public function hidden($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_hidden",1);
            return Response::ok();
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function display($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_hidden",0);
            return Response::ok();
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }


}