<?php

use Illuminate\Http\Request;
use App\Providers\RouteServiceProvider as Provider;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(["prefix" => "file", 'namespace' => Provider::getNamespace("file")],function(){
    //上传图片
    Route::post("/{uid}/{type}","File@upload");
    //编辑器上传
    Route::post("/editor/{uid}/{action}","File@editorUpload");
});

Route::group(["prefix" => "user", 'namespace' => Provider::getNamespace("member")],function(){
    //获取登录二维码图片
    Route::get("/code/{code?}","User@getLoginImg");
    //获取登录某个二维码状态
    Route::get("/status/{code}","User@getLoginStatus");
    //申请成为摄影师
    Route::post("/apply","User@Apply");
    //获取用户微信openid
    Route::get("/openid/{platform?}","User@getOAuth");
    //模糊搜索用户 支持使用mobile=?或nickname=? 方式，？表示字符串
    Route::get("/search","User@search");
});


Route::group(["prefix" => "article", 'namespace' => Provider::getNamespace("article")],function(){
    //攻略列表
    Route::get ("/"         , "Article@index");
    //改
    Route::put ("/{id}"     , "Article@update")->where(['id' => '\d+']);
    //新增
    Route::post("/"         , "Article@store");
    //详情
    Route::get ("/{id}"     , "Article@show")->where(['id' => '\d+']);
    //关系
    Route::get ("/{id}/relation/{relation}","Article@getRelate")->where(['id' => '\d+','relation'=>'\S+']);
    //隐藏
    Route::put ("/{id}/hidden" , "Article@hidden")->where(['id' => '\d+']);
    //显示
    Route::put ("/{id}/show"   , "Article@display")->where(['id' => '\d+']);
    //禁用
    Route::delete("/{id}"         ,"Article@destory");
    //解禁
    Route::put("/{id}/resume"     ,"Article@resume");
});

Route::group(["prefix" => "works", 'namespace' => Provider::getNamespace("works")],function(){
    //攻略列表  test ok
    Route::get ("/"         , "Works@index");
    //改
    Route::put ("/{id}"     , "Works@update")->where(['id' => '\d+']);
    //新增 如果是从套系中新建，sets填1
    Route::post("/{sets?}"         , "Works@store");
    //详情
    Route::get ("/{id}"     , "Works@show")->where(['id' => '\d+']);
    //关系
    Route::get ("/{id}/relation/{relation}","Works@getRelate")->where(['id' => '\d+','relation'=>'\S+']);
    //隐藏    test ok
    Route::put ("/{id}/hidden" , "Works@hidden")->where(['id' => '\d+']);
    //显示
    Route::put ("/{id}/show"   , "Works@display")->where(['id' => '\d+']);
    //禁用
    Route::delete("/{id}"         ,"Works@destory");
    //解禁
    Route::put("/{id}/resume"     ,"Works@resume");
    //设置封面
    Route::put("/{id}/{url}" ,   "Works@setCover");
});

Route::group(["prefix" => "keywords", 'namespace' => Provider::getNamespace("keywords")],function(){
    //全部关键词
    Route::get ("/"         , "Keywords@index");
    //热门关键词
    Route::get ("/hot"      , "Keywords@gethot");
});

Route::group(["prefix" => "photo", 'namespace' => Provider::getNamespace("photo")],function(){
    //全部选片
    Route::get ("/"         , "Photo@index");
    //新建
    Route::post("/"         , "Photo@store");
    //添加照片
    Route::post("/{id}"     , "Photo@images");
    //删除照片
    Route::delete("/{id}/{ids}","Photo@image");
    //照片列表
    Route::get ("/{id}/list"         , "Photo@lists");
    //详情
    Route::get ("/{id}"         , "Photo@show");
});


Route::group(["prefix" => "sets", 'namespace' => Provider::getNamespace("sets")],function(){
    //列表
    Route::get ("/"         , "Sets@index");
    //新建
    Route::post("/"         , "Sets@store");
    //改
    Route::put ("/{id}"     , "Sets@update")->where(['id' => '\d+']);
    //详情
    Route::get ("/{id}"     , "Sets@show");
    //禁用
    Route::delete("/{id}"     ,"Sets@destory");
    //解禁
    Route::put("/{id}/resume"     ,"Sets@resume");
});

Route::group(["prefix" => "category", 'namespace' => Provider::getNamespace("category")],function(){
    //列表
    Route::get ("/"         , "Category@index");
    //格式化分类
    Route::get ("/pretty"         , "Category@pretty");
    //某分类下的子分类
    Route::get ("/{id}/child"         , "Category@child")->where(['id' => '\d+']);
});

Route::group(["prefix" => "city", 'namespace' => Provider::getNamespace("city")],function() {
    //列表
    Route::get("/", "City@index");

    Route::get("/travel", "City@travel");
    //上一级信息
    Route::get("/{id}/parent","City@getParent");
    //获取详细信息
    Route::get("/{id}","City@show")->where(['id'=>'\d+']);
    //获取中国的ID
    Route::get("/china","City@china");
});