<?php

namespace App\Providers;

use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{

    protected static $Version;

    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = '';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        //
        parent::boot();
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        $this->mapApiRoutes();
    }

    /**
     * @return mixed
     */
    public static function getVersion()
    {
        return self::$Version;
    }


    public static function getNamespace($module)
    {
        $module = ucfirst($module);
        if (is_dir(__DIR__."/../".$module."/v".self::$Version)) {
            return "\\App\\Http\\Controllers\\".$module."\\v".self::$Version."\\Controller";
        } elseif(self::$Version !== "1" && is_dir(__DIR__."/../".$module."/v1")) {
            return "\\App\\Http\\Controllers\\".$module."\\v1"."\\Controller";
        } else {
            return "\\App\\Http\\Controllers\\".$module."\\Controller";
        }
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        self::$Version = 1;
        require base_path('routes/api.php');
    }
}
