<?php

namespace App\Http\Controllers\Works\Controller;

use App\Exceptions\ApiNotFound;
use App\Exceptions\ApiUnauthorized;
use App\Http\Controllers\ControllerBase;
use Illuminate\Routing\Controller;
use App\Lib\Response\Response;
use Illuminate\Http\Request;

class Works extends ControllerBase
{

    protected $prefix = "works";

    /**
     * test index ok
     * test del
     *
     *
     *
     */
    public function store(Request $request,$sets = null)
    {
        if (!$request->has("cover")) {
            if ($request->has("details")) {
                $details = $request->get("details");
                if (count($details) > 0) {
                    $cover = array_pop($details)["works_url"];
                    $request->merge(['cover' => $cover]);
                }
            }
        }
        if ($sets == 1) {
            $request->merge(['FROM_SETS' => 1]);
        }
        return parent::store($request);
    }


    public function hidden($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_hidden",1);
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function display($id)
    {
        try {
            $this->isAllowed($id);
            $this->prop($id,"is_hidden",0);
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 设置封面
     * @param $id
     * @param $cover_id
     */
    public function setCover($id,$url)
    {
        try {
            $this->isAllowed($id);
            $client = app("client");
            $client->put("/works/$id",['cover' => $url]);
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }


}