<?php
namespace App\Http\Controllers\Photo\Controller;

use App\Exceptions\ApiNotFound;
use App\Http\Controllers\ControllerBase;
use Illuminate\Http\Request;
use App\Lib\Response\Response;

class Photo extends ControllerBase
{

    protected $prefix = "photo";

    /**
     * 添加照片
     * @method  post
     * route /photo/{id}
     */
    public function images($id,Request $request)
    {
        try {
            $client = app("client");
            $client->post($this->prefix."/".$id,$request->all());
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 删除照片
     * @method delete
     * @route  /photo/id/ids;
     */
    public function image($id,$ids)
    {
        try {
            parent::isAllowed($id);
            $client = app("client");
            $client->delete($this->prefix."/$id/$ids");
            return Response::ok();
        } catch (ApiNotFound $e) {
            return Response::error($e->getMessage());
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }


    public function show($id,$query = "",$checkUid = true)
    {
        try {
            $client = app("client");
            $res = $client->get($this->prefix."/".$id);
            $this->isAllowed($id,$res);
            return Response::success($res);
        } catch (ApiNotFound $e) {
            return Response::error($e->getMessage());
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 新建
     */
    public function store(Request $request)
    {
        try {
            $client = app("client");
            $client->post($this->prefix,array_merge($request->all(),['pg_id' => $this->getAuth()]));
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 列表
     */
    public function lists($id)
    {
        try {
            $this->isAllowed($id);
            $client = app("client");
            $client->setMethod("get");
            $client->setUrl($this->prefix."/$id/list");
            $res = $client->curl();
            return Response::success($res);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    protected function isAllowed($id, $data = [])
    {
        $uid = $this->getAuth();
        $result = false;
        if (!empty($data)) {
            $result = ($data->pg_id == $uid);
        } else {
            $client = app("client");
            $client->setUrl($this->prefix."/".$id);
            $client->setMethod("get");
            $res = $client->curl();
            $result = ($res->pg_id == $uid);
        }
        if ($result == false) {
            throw new ApiNotFound("未找到");
        }
    }
}