<?php

namespace App\Http\Controllers\Member\Controller;

use App\Exceptions\ApiForbidden;
use App\Exceptions\ApiTimeout;
use App\Http\Controllers\ControllerBase;
use App\Lib\Response\HttpStatus;
use App\Lib\Response\Response;
use App\Exceptions\ApiUnauthorized;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class User extends ControllerBase
{
    /**
     * 获取一个登录二维码
     * @method get
     * @param $code optional
     * router /user/code/code\S*
     */
    public function getLoginImg($code = null)
    {
        try {
            $client = app("client");
            $client->setUrl("user/auth/code/".$code);
            $client->setMethod("get");
            $res = $client->curl();
            $qrcode = app("qrcode");
            $qrcode->setText($res);
            $img = $qrcode->getImage();
            return Response::success($this->getImage($img),$res);
        } catch (\Exception $e){
            return Response::error($e->getMessage());
        }
    }

    /**
     * 获取登录状态
     * @method get
     * @param $code required
     * @router /user/status/code\S+
     */
    public function getLoginStatus($code)
    {
        try {
            $client = app("client");
            $client->setUrl("user/show/" . $code);
            $client->setMethod("get");
            $res = $client->curl();
            if (is_array($res)) {
                $res['avatar'] = $this->ImgEncode($res['avatar']);
            } elseif (is_object($res)) {
                $res->avatar = $this->ImgEncode($res->avatar);
            }
            return Response::success($res);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (ApiTimeout $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpTimeout);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    protected function getImage($resource)
    {
        $stream = null;
        ob_start();
        header("Content-type: image/png");
        imagepng($resource);
        $stream = base64_encode(ob_get_contents());
        ob_end_clean();
        return "data:imge/png;base64,".$stream;
    }

    /**
     * 申请成为摄影师
     * @method get
     * @param $code required
     * @router /user/apply
     */
    public function Apply(Request $request)
    {
        try {
            $uid = $this->getAuth();
            $client = app("client");
            $client->setUrl("ident/" . $uid);
            $client->setMethod("post");
            $client->setData($request->all());
            $res = $client->curl();
            return Response::success($res);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(),HttpStatus::HttpUnauthorized);
        } catch (ApiForbidden $e) {
            return Response::error("您已申请摄影师",HttpStatus::HttpForbidden);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 获取第三方OPENID
     */
    public function getOAuth($platform = "") {
        try {
            empty($platform) && $platform = "wx";
            $this->prefix = "user";
            $res = parent::show($this->getAuth(),$this->combine(['relation' => 'third']));
            $data = $this->filter($res['data']->relation_third,function($item) use ($platform){
                if ($item->platform == $platform) {
                    return $item->token;
                }
            });
            if (count($data) > 0) {
                $data = $data[0];
            }
            return Response::success($data->token);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(),HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    /**
     * 模糊搜索用户
     */
    public function search()
    {
        $query = request()->getQueryString();
        try {
            $client = app("client");
            $client->setUrl("user/search?".$query);
            $client->setMethod("get");
            $res = $client->curl();
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }


    protected function ImgEncode($url)
    {
        $curl = curl_init();
        curl_setopt($curl,CURLOPT_URL,$url);
        curl_setopt($curl,CURLOPT_CUSTOMREQUEST,"HEAD");
        curl_setopt($curl, CURLOPT_NOBODY, true);
        curl_exec($curl);
        $info = curl_getinfo($curl);
        if ($info['http_code'] >= 400) {
           $url = "http://yuepai.b0.upaiyun.com/default/default_avatar.png";
        }
        $token = base64_encode($url);
        if (!Cache::has($token));
        {
            $image_info = getimagesize($url);
            $image_data = chunk_split(
                base64_encode(
                    file_get_contents($url, false,
                        stream_context_create([
                        'http' => [
                            'method' => "GET",
                            'timeout' => 10
                            ]
                        ])
                    )
                )
            );
            Cache::put($token, "data:{$image_info['mime']};base64," . $image_data , 60*24);
        }
        return Cache::get($token);
    }
}