<?php
/**
 * Created by PhpStorm.
 * User: zhuangxin
 * Date: 16-9-22
 * Time: 上午10:12
 */

namespace App\Http\Controllers;


use App\Exceptions\ApiNotFound;
use App\Exceptions\ApiUnauthorized;
use App\Lib\Client\CurlClient;
use App\Lib\Response\Response;
use \Illuminate\Http\Request;
use \Closure;


class ControllerBase
{
    public function getAuth()
    {
        return request("uuid",3);
        static $id;
        if (!$id) {
            $code = request()->header("token");
            $client = app("client");
            $client->setUrl("user/getid/" . $code);
            $client->setMethod("get");
            $id = $client->curl();
        }
        return $id;
    }

    public function index($query = "",$checkUid = true)
    {
        empty($query) && $query = request()->getQueryString();
        try {
            $client = app("client");
            if ($checkUid === true) {
                $uid = $this->getAuth();
                $query .= "&uid=" . $uid;
            }
            $res = $client->get($this->prefix."?".$query);
            $res = $this->after_hook($res);
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function store(Request $request)
    {
        try {
            $client = app("client");
            $client->setMethod("post");
            $post = array_merge($request->all(),['uid' => $this->getAuth()]);
            $client->setData($post);
            $client->setUrl($this->prefix);
            $model_id = $client->curl();
            return Response::ok($model_id);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function update($id,Request $request)
    {
        try {
            $this->isAllowed($id);
            $client = app("client");
            $client->setMethod("put");
            $post = array_merge($request->all(),['uid' => $this->getAuth()]);
            $client->setData($post);
            $model_id = $client->curl();
            return Response::ok($model_id);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function show($id,$query = "",$checkUid = true)
    {
        try {
            $client = app("client");
            $url = $this->prefix."/".$id;
            if (!empty($query)) {
                $url .= "?".$query;
            }
            $client->setUrl($url);
            $client->setMethod("get");
            $res = $client->curl();
            if ($checkUid === true) {
                $this->isAllowed($id, $res);
            }
            return Response::success($res);
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function destory($id)
    {
        try {
            $client = app("client");
            $this->isAllowed($id);
            $client->put($id, ['is_del' => 1]);
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function resume($id)
    {
        try {
            $client = app("client");
            $this->isAllowed($id);
            $client->put($id, ['is_del' => 0]);
            return Response::ok();
        } catch (ApiUnauthorized $e) {
            return Response::error($e->getMessage(), HttpStatus::HttpUnauthorized);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function prop($id,$key,$value)
    {
        $client = app("client");
        $client->setUrl($this->prefix."/".$id);
        $client->setMethod("put");
        $client->setData([$key => $value]);
        $res = $client->curl();
        return $res;
    }

    protected function isAllowed($id,$data = [])
    {
        return true;
        $uid = $this->getAuth();
        $result = false;
        if (!empty($data)) {
            $result = ($data->uid == $uid);
        } else {
            $client = app("client");
            $client->setUrl($this->prefix."/".$id);
            $client->setMethod("get");
            $res = $client->curl();
            $result = ($res->uid == $uid);
        }
        if ($result == false) {
            throw new ApiNotFound("未找到");
        }
    }

    protected function combine(array $arr)
    {
        $query = request()->getQueryString();
        $res = [];
        foreach($arr as $k => $item)
        {
            $res[] = $k."=".$item;
        }
        return $query . "&" .implode("&",$res);
    }

    protected function filter($data,$func)
    {
        $result = [];
        foreach ($data as $item) {
            if (call_user_func($func,$item)) {
                $result[] = $item;
            }
        }
        return $result;
    }

    protected function after_hook($res) {
        return $res;
    }
}