<?php

namespace App\Http\Controllers\City\Controller;

use App\Http\Controllers\ControllerBase;
use App\Lib\Response\Response;


class City extends ControllerBase
{
    protected $prefix = "city";

    public function getParent($id)
    {
        $client = app("client");
        try {
            $res = $client->get($this->prefix."/$id/parent");
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function index($query = "", $checkUid = true)
    {
        return parent::index($query, false);
    }

    public function china()
    {
        $query = $this->combine(['name'=>'中国']);
        return parent::index($query,false);
    }

    public function show($id, $query = "", $checkUid = true)
    {
        return parent::show($id, $query, false);
    }

    public function travel()
    {
        empty($query) && $query = request()->getQueryString();
        try {
            $client = app("client");
            $res = $client->get($this->prefix.'/travel'."?".$query);
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

}