<?php
namespace App\Http\Controllers\Category\Controller;

use App\Http\Controllers\ControllerBase;
use App\Lib\Response\Response;

class Category extends ControllerBase
{

    protected $prefix = "cates";

    public function pretty()
    {
        try {
            $client = app("client");
            $client->setUrl($this->prefix."/pretty");
            $client->setMethod("get");
            $res = $client->curl();
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }

    public function index($query = "", $checkUid = true)
    {
        $query = $this->combine(['size' => 1000]);
        return parent::index($query, $checkUid);
    }


    public function child($id)
    {
        try {
            $client = app("client");
            $res = $client->get($this->prefix."/".$id."/child");
            return Response::success($res);
        } catch (\Exception $e) {
            return Response::error($e->getMessage());
        }
    }



}